package de.mse.uebung6.aufgabe1;

import java.util.ArrayList;
import java.util.List;

class MovieRankSearch {

   ArrayList<Movie> list;

   // Konstruktor
   public MovieRankSearch() {
      list = new ArrayList<Movie>();
   }

   public void insertMovieWithRank(int rank, Movie movie) {
      list.add(movie);
   }

   public Movie getMovieForRank(int rank) {
      return list.get(rank - 1);
   }

   // Dieser Client verwendet Ihre Implementierung
   public static void main(String[] args) {
      MovieRankSearch movieSearch = new MovieRankSearch();

      // Filme einfuegen
      List<Movie> movies = Movie.readMoviesFromFile("mse/src/de/mse/uebung6/aufgabe1/movies.txt");
      for (Movie m : movies) {
         movieSearch.insertMovieWithRank(m.rank, m);
      }

      // Punktzugriff
      Movie movie = movieSearch.getMovieForRank(42);

      // Ausgabe
      System.out.println(movie);
   }
}